/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.core.internal.diagnostic;

import com.aptana.core.CorePlugin;
import com.aptana.core.diagnostic.IDiagnosticLog;
import com.aptana.core.diagnostic.IDiagnosticManager;
import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.CollectionsUtil;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.IConfigurationElementProcessor;
import com.aptana.core.util.StringUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Plugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiagnosticManager
implements IDiagnosticManager {
    private static final String EXTENSION_NAME = "diagnostic";
    private static final String ELEMENT_LOG = "diagnosticLog";
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_PRIORITY = "priority";
    private static final int DEFAULT_PRIORITY = 50;
    private List<IDiagnosticLog> logs;

    @Override
    public List<IDiagnosticLog> getLogs() {
        this.loadExtensions();
        return this.logs;
    }

    private synchronized void loadExtensions() {
        if (this.logs != null) {
            return;
        }
        final ArrayList result = new ArrayList();
        EclipseUtil.processConfigurationElements("com.aptana.core", EXTENSION_NAME, new IConfigurationElementProcessor(){

            @Override
            public void processElement(IConfigurationElement element) {
                String classStr = element.getAttribute(DiagnosticManager.ATTR_CLASS);
                if (StringUtil.isEmpty(classStr)) {
                    return;
                }
                result.add(new LazyDiagnosticLog(element));
            }

            @Override
            public Set<String> getSupportElementNames() {
                return CollectionsUtil.newSet(DiagnosticManager.ELEMENT_LOG);
            }
        });
        Collections.sort(result, new Comparator<LazyDiagnosticLog>(){

            @Override
            public int compare(LazyDiagnosticLog arg0, LazyDiagnosticLog arg1) {
                return arg0.getPriority() - arg1.getPriority();
            }
        });
        this.logs = Collections.unmodifiableList(new ArrayList(result));
    }

    private static class LazyDiagnosticLog
    implements IDiagnosticLog {
        public IDiagnosticLog logClass;
        public Integer priority;
        private IConfigurationElement element;

        private LazyDiagnosticLog(IConfigurationElement element) {
            this.element = element;
        }

        private synchronized int getPriority() {
            if (this.priority == null) {
                this.priority = 50;
                String priorityStr = this.element.getAttribute(DiagnosticManager.ATTR_PRIORITY);
                if (!StringUtil.isEmpty(priorityStr)) {
                    try {
                        this.priority = Integer.parseInt(priorityStr);
                    }
                    catch (NumberFormatException e) {
                        IdeLog.logWarning((Plugin)CorePlugin.getDefault(), "The priority for diagnosticLog needs to be an integer.", e);
                    }
                }
            }
            return this.priority;
        }

        private synchronized IDiagnosticLog getWrapped() {
            if (this.logClass == null) {
                this.logClass = new NullDiagnosticLog();
                try {
                    Object clazz = this.element.createExecutableExtension(DiagnosticManager.ATTR_CLASS);
                    if (clazz instanceof IDiagnosticLog) {
                        this.logClass = (IDiagnosticLog)clazz;
                    } else {
                        IdeLog.logWarning((Plugin)CorePlugin.getDefault(), MessageFormat.format("The class {0} does not implement IDiagnosticLog.", this.element.getAttribute(DiagnosticManager.ATTR_CLASS)));
                    }
                }
                catch (CoreException e) {
                    IdeLog.logError((Plugin)CorePlugin.getDefault(), e);
                }
            }
            return this.logClass;
        }

        public String getLog() {
            return this.getWrapped().getLog();
        }
    }

    private static final class NullDiagnosticLog
    implements IDiagnosticLog {
        private NullDiagnosticLog() {
        }

        public String getLog() {
            return "";
        }
    }
}

